﻿'/***************************************************************************/
'/**                                                                       **/
'/**                               MAGICARD                                **/
'/**                                                                       **/
'/***************************************************************************/
'/**                                                                       **/
'/**  PROJECT      : SDK VB Demo - DTC Printers                            **/
'/**                                                                       **/
'/**  MODULE NAME  : Main.vb                                               **/
'/**                                                                       **/
'/**  COPYRIGHT    : Magicard                                              **/
'/**                                                                       **/
'/***************************************************************************/

Partial Public Class Main

#Region "=== Initialisation ==="

    Private hSession As IntPtr = IntPtr.Zero
    Private printerType As SDK.PrinterType = SDK.PrinterType.None
    Private hDC As IntPtr = IntPtr.Zero
    Private ps As New PrinterSettings
    Private pd As New PrintDialog()
    Private g As Graphics

    Private InfoTabInit As Boolean = False
    Private EncodingTabInit As Boolean = False
    Private Driver1TabInit As Boolean = False
    Private Driver2TabInit As Boolean = False
    Private PrintDemoTabInit As Boolean = False
    Private UtilsTabInit As Boolean = False

    Public Sub New()
        InitializeComponent()

#If (x86) Then
        Me.Text = "DTC SDK VB Demo (32 bit)"
#Else
        Me.Text = "DTC SDK VB Demo (64 bit)"
#End If

        'Hide tabs other than Printer Settings
        TabControl.Controls.Remove(Information)
        TabControl.Controls.Remove(Encoding)
        TabControl.Controls.Remove(Driver1)
        TabControl.Controls.Remove(Driver2)
        TabControl.Controls.Remove(PrintDemo)
        TabControl.Controls.Remove(Utils)

        'Initialise the individual tabs
        InitPrinterTab()
        InitInfoTab()
        InitEncodingTab()
        InitDriver1Tab()
        InitDriver2Tab()
        InitPrintDemoTab()
        InitUtilsTab()
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Local Methods ==="

    Private Sub TabControl_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) _
                Handles TabControl.SelectedIndexChanged
        Dim Area As New SDK.Area

        Select Case TabControl.SelectedIndex
            Case 1
                If InfoTabInit = False Then
                    InfoTabInit = True

                    If printerType = SDK.PrinterType.Generation2 Then
                        PasswordButton.Enabled = False
                        Password1.Enabled = False
                        Password2.Enabled = False
                        PasswordCommand.Enabled = False
                        Pwd1Label.Enabled = False
                        Pwd2Label.Enabled = False

                        For Each p As ParamSet In paramTable
                            ParamCombo.Items.Add(p.Text)
                        Next

                        ParamCombo.SelectedIndex = 0
                    Else
                        Generation2GroupBox.Visible = False
                    End If
                End If

            Case 2
                If EncodingTabInit = False Then
                    EncodingTabInit = True

                    If printerType = SDK.PrinterType.Generation2 Then
                        ParityLabel.Visible = False
                        LRCLabel.Visible = False
                        T1_ParityCombo.Visible = False
                        T2_ParityCombo.Visible = False
                        T3_ParityCombo.Visible = False
                        T1_LRCCombo.Visible = False
                        T2_LRCCombo.Visible = False
                        T3_LRCCombo.Visible = False
                        MagStartButton.Enabled = True
                        EncodingGetRadio.Enabled = True
                        EncodingSetRadio.Enabled = True

                        '...Magnetic Encoding Start Position
                        Dim MagStart As Integer = 0
                        GetMagStart(MagStart)
                    End If
                End If

            Case 3
                'Always check and uopdate resolution
                If PrinterIs600DPICapable() Then
                    Dim resolution As Byte = 0
                    GetResolution(resolution)
                    ResolutionButton.Enabled = True
                End If

                If Driver1TabInit = False Then
                    Driver1TabInit = True

                    If printerType = SDK.PrinterType.Generation2 Then
                        PrintSpeedButton.Visible = False
                        PrintSpeedCombo.Visible = False
                        EraseEndPowerLabel.Visible = False
                        ErasePowerEndUpDown.Visible = False
                        WritePowerLabel.Visible = False
                        WritePowerUpDown.Visible = False

                        YMCPowerUpDown.Minimum = -100
                        ResinPowerUpDown.Minimum = -100
                        OvercoatPowerUpDown.Minimum = -100

                        ResinAreaLeftUpDown.Maximum = SDK.ID_CardWidth(hSession) - 1
                        ResinAreaWidthUpDown.Maximum = SDK.ID_CardWidth(hSession)
                        PrintableAreaLeftUpDown.Maximum = SDK.ID_CardWidth(hSession) - 1
                        PrintableAreaWidthUpDown.Maximum = SDK.ID_CardWidth(hSession)
                        AreaHoleLeftUpDown.Maximum = SDK.ID_CardWidth(hSession) - 1
                        AreaHoleWidthUpDown.Maximum = SDK.ID_CardWidth(hSession)
                        EraseAreaLeftUpDown.Maximum = SDK.ID_CardWidth(hSession) - 1
                        EraseAreaWidthUpDown.Maximum = SDK.ID_CardWidth(hSession)

                        '...Printable Area
                        GetPrintableArea(Area)
                    Else
                        PrintSpeedButton.Visible = True
                        PrintSpeedCombo.Visible = True
                        EraseEndPowerLabel.Visible = True
                        ErasePowerEndUpDown.Visible = True
                        WritePowerLabel.Visible = True
                        WritePowerUpDown.Visible = True

                        YMCPowerUpDown.Minimum = 0
                        ResinPowerUpDown.Minimum = 0
                        OvercoatPowerUpDown.Minimum = 0

                        PrintSpeedButton.Enabled = True

                        '...Print Speed
                        Dim PrintSpeed As New SDK.PrintSpeed
                        GetPrintSpeed(PrintSpeed)
                    End If

                    'Initialise the Controls on the Driver 1 Page...
                    '...GUIControl
                    Dim control As New SDK.GUIControl
                    GetGUIControl(control)

                    '...Sharpness
                    Dim temp As New Byte
                    GetSharpness(temp)

                    '...Colour Correction
                    Dim Correction As New SDK.Correction
                    GetColourCorrection(Correction)

                    '...Power Level
                    Dim PowerLevel As New SDK.PowerLevel
                    GetPowerLevels(PowerLevel)

                    '...Resin Area
                    GetResinArea(SDK.Side.Front, 1, Area)

                    '...AreaHole(s)
                    GetAreaHole(SDK.Side.Front, SDK.AreaHole.Area, 1, Area)

                    '...Rewritable
                    Dim Rewritable As New SDK.Rewritable
                    GetRewritable(Rewritable)
                End If

            Case 4
                If Driver2TabInit = False Then
                    Driver2TabInit = True

                    'Get the card sizes from the Printer
                    For Each p As PaperSize In pd.PrinterSettings.PaperSizes
                        cardsizekp.Add(p.RawKind, p.PaperName)
                    Next

                    'Initialise the Card Size Combo Box
                    CardSizeCombo.DataSource = New BindingSource(cardsizekp, Nothing)
                    CardSizeCombo.DisplayMember = "Value"
                    CardSizeCombo.ValueMember = "Key"

                    'Initialise the Controls on the Driver 2 Page...
                    '...Print Settings
                    Dim printSettings As New SDK.PrintSetting
                    GetPrintSettings(printSettings)

                    '...Card Settings
                    Dim cardSettings As New SDK.CardSetting
                    GetCardSettings(SDK.Side.Front, cardSettings)

                    '...HoloKote
                    Dim HoloKote As New SDK.HoloKote
                    GetHoloKote(SDK.Side.Front, HoloKote)

                    '...HoloPatch
                    Dim HoloPatch As New SDK.HoloPatch
                    GetHoloPatch(HoloPatch)

                    '...ColourArea
                    ColourAreaLeftUpDown.Maximum = SDK.ID_CardWidth(hSession) - 1
                    ColourAreaWidthUpDown.Maximum = SDK.ID_CardWidth(hSession)
                    Dim Correction As New SDK.Correction
                    GetColourArea(SDK.Side.Front, 1, Area, Correction)

                    '...ColourAdjust
                    Dim colourAdj As New SDK.ColorAdjustment
                    GetColourAdjust(colourAdj)
                End If

            Case 5
                If PrintDemoTabInit = False Then
                    PrintDemoTabInit = False

                    TextFrontColourCombo.Text = "Green"
                    ShapeFrontOutlineCombo.Text = "Green"
                    ShapeFrontFillCombo.Text = "Transparent"
                    LineFrontColourCombo.Text = "Green"
                    TextBackColourCombo.Text = "Black"
                    ShapeBackOutlineCombo.Text = "Black"
                    ShapeBackFillCombo.Text = "Transparent"
                    LineBackColourCombo.Text = "Black"
                End If
                Functions600DPI.Visible = PrinterIs600DPICapable()
                Functions600DPI.Checked = Radio600DPI.Checked

            Case 6
                If UtilsTabInit = False Then
                    UtilsTabInit = False

                    If printerType <> SDK.PrinterType.Generation2 Then
                        SendAPDUBox.Enabled = False
                        SendAPDUButton.Enabled = False
                    End If
                End If
        End Select
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Child Methods ==="

    Private Sub HandleError(Action As String, Result As SDK.Return)
        Dim ErrorMsg As String

        Select Case Result
            Case SDK.Return.Timeout
                ErrorMsg = "MAGICARD_TIMEOUT"

            Case SDK.Return.Error
                ErrorMsg = "MAGICARD_ERROR"

            Case SDK.Return.PrinterError
                ErrorMsg = "MAGICARD_PRINTER_ERROR"

            Case SDK.Return.DriverNotCompliant
                ErrorMsg = "MAGICARD_DRIVER_NOTCOMPLIANT"

            Case SDK.Return.OpenPrinterError
                ErrorMsg = "MAGICARD_OPENPRINTER_ERROR"

            Case SDK.Return.RemoteCommError
                ErrorMsg = "MAGICARD_REMOTECOMM_ERROR"

            Case SDK.Return.LocalCommError
                ErrorMsg = "MAGICARD_LOCALCOMM_ERROR"

            Case SDK.Return.SpoolerNotEmpty
                ErrorMsg = "MAGICARD_SPOOLER_NOT_EMPTY"

            Case SDK.Return.RemoteCommInUse
                ErrorMsg = "MAGICARD_REMOTECOMM_IN_USE"

            Case SDK.Return.LocalCommInUse
                ErrorMsg = "MAGICARD_LOCALCOMM_IN_USE"

            Case SDK.Return.ParamError
                ErrorMsg = "ID_PARAM_ERROR"

            Case SDK.Return.InvalidSession
                ErrorMsg = "ID_INVALID_SESSION"

            Case SDK.Return.MoreData
                ErrorMsg = "ID_MORE_DATA"

            Case SDK.Return.InvalidPrinter
                ErrorMsg = "ID_INVALID_PRINTER"

            Case SDK.Return.InvalidAction
                ErrorMsg = "ID_INVALID_ACTION"

            Case SDK.Return.ReadError
                ErrorMsg = "ID_READ_ERROR"

            Case SDK.Return.WriteError
                ErrorMsg = "ID_WRITE_ERROR"
				
			Case SDK.Return.NoMagData
				ErrorMsg = "ID_NO_MAG_DATA"

            Case Else
                ErrorMsg = String.Format("Unknown API Error ({0})", Result)
        End Select

        MessageBox.Show(Action + ": " + ErrorMsg)
    End Sub

    Private Sub WaitForPrinterToFinish()
        If pd.PrintToFile Then
            Return
        End If

        If printerType = SDK.PrinterType.Generation2 Then
            Return
        End If

        Cursor.Current = Cursors.WaitCursor

        Dim SDKReturn As SDK.Return

        Do
            'Repeat the wait until response is not timeout
            SDKReturn = SDK.ID_WaitForPrinter(hSession)
        Loop While (SDKReturn = SDK.Return.Timeout)

        Cursor.Current = Cursors.Default
    End Sub

    Private Function Separator(Action As SDK.Action) As String
        If Action = SDK.Action.Read Then
            Return ": "
        Else
            Return " -> "
        End If
    End Function

    Private Sub ExitButton_Click(sender As System.Object, e As System.EventArgs) _
                Handles ExitButton.Click
        Application.Exit()
    End Sub

#End Region

End Class
